//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QKeySequence;
import org.kde.qt.QtSupport;

/**

 The KShortcut class is used to represent a keyboard shortcut to an action.
 A shortcut is normally a single key with modifiers, such as Ctrl+V.
 A KShortcut object may also contain an alternate key which will also
 activate the action it's associated to, as long as no other actions have
 defined that key as their primary key.  Ex: Ctrl+V;Shift+Insert.
 This can be used to add additional accelerators to a KAction.  For example,
 the below code binds the escape key to the close action.
 <pre>
  KAction closeAction = KStdAction.close( this, SLOT("close()"), actionCollection() );
  KShortcut closeShortcut = closeAction.shortcut();
  closeShortcut.append( KKey(Key_Escape));
  closeAction.setShortcut(closeShortcut);
 </pre>
 Note that a shortcut cannot have more than 2 key combinations associated with it, so the above
 code would not do anything (and append() would return false) if the closeAction already had
 an key and alternate key.
		@short    The KShortcut class is used to represent a keyboard shortcut to an action.

*/
public class KShortcut implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KShortcut(Class dummy){}

	/**	
		 The maximum number of key sequences that can be contained in
		 a KShortcut.
		         		@short    The maximum number of key sequences that can be contained in  a KShortcut.
	*/
	public static final int MAX_SEQUENCES = 2;

	/**	
		 Creates a new null shortcut.
				@short    Creates a new null shortcut.
		@see #null
		@see #isNull
		@see #clear
	*/
	public KShortcut() {
		newKShortcut();
	}
	private native void newKShortcut();
	/**	
		 Creates a new shortcut with the given Qt key code
		 as the only key sequence.
			@param keyQt the qt keycode
				@short    Creates a new shortcut with the given Qt key code  as the only key sequence.
		@see org.kde.qt.Qt#Key
	*/
	public KShortcut(int keyQt) {
		newKShortcut(keyQt);
	}
	private native void newKShortcut(int keyQt);
	/**	
		 Creates a new shortcut that contains only the given qt key
		 sequence.
			@param keySeq the qt key sequence to add
			 		@short    Creates a new shortcut that contains only the given qt key  sequence.
	*/
	public KShortcut(QKeySequence keySeq) {
		newKShortcut(keySeq);
	}
	private native void newKShortcut(QKeySequence keySeq);
	/**	
		 Creates a new shortcut that contains only the given key
		 in its only sequence.
			@param key the key to add
			 		@short    Creates a new shortcut that contains only the given key  in its only sequence.
	*/
	public KShortcut(KKey key) {
		newKShortcut(key);
	}
	private native void newKShortcut(KKey key);
	/**	
		 Creates a new shortcut that contains only the given key
		 sequence.
			@param keySeq the key sequence to add
			 		@short    Creates a new shortcut that contains only the given key  sequence.
	*/
	public KShortcut(KKeySequence keySeq) {
		newKShortcut(keySeq);
	}
	private native void newKShortcut(KKeySequence keySeq);
	/**	
		 Copies the given shortcut.
			@param shortcut the shortcut to add
			 		@short    Copies the given shortcut.
	*/
	public KShortcut(KShortcut shortcut) {
		newKShortcut(shortcut);
	}
	private native void newKShortcut(KShortcut shortcut);
	/**	
		 Creates a new key sequence that contains the given key sequence.
		 The description consists of semicolon-separated keys as
		 used in KKeySequence.KKeySequence(String).
			@param shortcut the description of the key
				@short    Creates a new key sequence that contains the given key sequence.
		@see KKeySequence#KKeySequence(const
	*/
	public KShortcut(String shortcut) {
		newKShortcut(shortcut);
	}
	private native void newKShortcut(String shortcut);
	/**	
		 Clears the shortcut. The shortcut is null after calling this
		 function.
				@short    Clears the shortcut.
		@see #isNull
	*/
	public native void clear();
	/**	
		 Initializes the shortcut with the given Qt key code
		 as the only key sequence.
			@param keyQt the qt keycode
				@short    Initializes the shortcut with the given Qt key code  as the only key sequence.
		@see org.kde.qt.Qt#Key
	*/
	public native boolean init(int keyQt);
	/**	
		 Initializes the shortcut with the given qt key sequence.
			@param keySeq the qt key sequence to add
			 		@short    Initializes the shortcut with the given qt key sequence.
	*/
	public native boolean init(QKeySequence keySeq);
	/**	
		 Initializes the shortcut with the given key as its only sequence.
			@param key the key to add
			 		@short    Initializes the shortcut with the given key as its only sequence.
	*/
	public native boolean init(KKey key);
	/**	
		 Initializes the shortcut with the given qt key sequence.
			@param keySeq the qt key sequence to add
			 		@short    Initializes the shortcut with the given qt key sequence.
	*/
	public native boolean init(KKeySequence keySeq);
	/**	
		 Copies the given shortcut.
			@param shortcut the shortcut to add
			 		@short    Copies the given shortcut.
	*/
	public native boolean init(KShortcut shortcut);
	/**	
		 Initializes the key sequence with the given key sequence.
		 The description consists of semicolon-separated keys as
		 used in KKeySequence.KKeySequence(String).
			@param shortcut the description of the key
				@short    Initializes the key sequence with the given key sequence.
		@see KKeySequence#KKeySequence(const
	*/
	public native boolean init(String shortcut);
	/**	
		 Returns the number of sequences that are in this
		 shortcut.
				@return the number of sequences
 MAX_SEQUENCES
	 
		@short    Returns the number of sequences that are in this  shortcut.
	*/
	public native int count();
	/**	
		 Returns the <code>i</code>'th key sequence of this shortcut.
			@param i the number of the key sequence to retrieve
				@return the <code>i</code>'th sequence or KKeySequence.null() if
         there are less than <code>i</code> key sequences
 MAX_SEQUENCES
	 
		@short    Returns the <code>i</code>'th key sequence of this shortcut.
	*/
	public native KKeySequence seq(int i);
	/**	
		 Returns the key code of the first key sequence, or
		 null if there is no first key sequence.
				@return the key code of the first sequence's first key

		@short    Returns the key code of the first key sequence, or  null if there is no first key sequence.
		@see org.kde.qt.Qt#Key
		@see KKeySequence#keyCodeQt
	*/
	public native int keyCodeQt();
	/**	
		 Returns true if the shortcut is null (after clear() or empty
		 constructor).
				@return true if the shortcut is null

		@short    Returns true if the shortcut is null (after clear() or empty  constructor).
		@see #clear
		@see #null
	*/
	public native boolean isNull();
	/**	
		 Compares this object with the given shortcut. Returns a negative
		 number if the given shortcut is larger, 0 if they are equal and
		 a positive number this shortcut is larger. Shortcuts are
		 compared by comparing the individual key sequences, starting from the
		 beginning until an unequal key sequences has been found. If a shortcut
		 contains more key sequences, it is considered larger.
			@param shortcut the shortcut to compare to
				@return a negative number if the given KShortcut is larger, 0 if
 they are equal and a positive number this KShortcut is larger

		@short    Compares this object with the given shortcut.
		@see KKey#compare
		@see KKeyShortcut#compare
	*/
	public native int compare(KShortcut shortcut);
	/**	
		 Compares the sequences of both shortcuts.
				@short    Compares the sequences of both shortcuts.
		@see #compare
	*/
	public native boolean op_equals(KShortcut cut);
	/**	
		 Compares the sequences of both shortcuts.
				@short    Compares the sequences of both shortcuts.
		@see #compare
	*/
	public native boolean op_not_equals(KShortcut cut);
	/**	
		 Compares the sequences of both shortcuts.
				@short    Compares the sequences of both shortcuts.
		@see #compare
	*/
	public native boolean op_lt(KShortcut cut);
	/**	
		 Checks whether this shortcut contains a sequence that starts
		 with the given key.
			@param key the key to check
				@return true if a key sequence starts with the key
	 
		@short    Checks whether this shortcut contains a sequence that starts  with the given key.
	*/
	public native boolean contains(KKey key);
	/**	
		 Checks whether this shortcut contains the given sequence.
			@param keySeq the key sequence to check
				@return true if the shortcut has the given key sequence
	 
		@short    Checks whether this shortcut contains the given sequence.
	*/
	public native boolean contains(KKeySequence keySeq);
	/**	
		 Sets the <code>i</code> 'th key sequence of the shortcut. You can not introduce
		 gaps in the list of sequences, so you must use an <code>i</code> <= count().
		 Also note that the maximum number of key sequences is MAX_SEQUENCES.
			@param i the position of the new key sequence(0 <= i <= count(), 0 <= i < MAX_SEQUENCES)
			@param keySeq the key sequence to set
				@return true if successful, false otherwise
	 
		@short    Sets the <code>i</code> 'th key sequence of the shortcut.
	*/
	public native boolean setSeq(int i, KKeySequence keySeq);
	/**	
		 Appends the given key sequence.  This sets it as either the keysequence or
		 the alternate keysequence.  If the shortcut already has MAX_SEQUENCES
		 sequences then this call does nothing, and returns false.
			@param keySeq the key sequence to add
				@return true if successful, false otherwise

		@short    Appends the given key sequence.
		@see #setSeq
	*/
	public native boolean append(KKeySequence keySeq);
	/**	
		 Removes the given key sequence from this shortcut
			@param keySeq the key sequence to remove
				@short    Removes the given key sequence from this shortcut
	*/
	public native void remove(KKeySequence keySeq);
	/**	
		 Appends the given key
			@param spec the key to add
				@return true if successful, false otherwise

		@short    Appends the given key 
		@see #setSeq
		@see MAX_SEQUENCES
	*/
	public native boolean append(KKey spec);
	/**	
		 Appends the sequences from the given shortcut.
			@param cut the shortcut to append
				@return true if successful, false otherwise

		@short    Appends the sequences from the given shortcut.
		@see MAX_SEQUENCES
	*/
	public native boolean append(KShortcut cut);
	/**	
		 Returns a description of the shortcut as semicolon-separated
		 ket sequences, as returned by KKeySequence.toString().
				@return the string represenation of this shortcut

		@short    Returns a description of the shortcut as semicolon-separated  ket sequences, as returned by KKeySequence.toString().
		@see KKey#toString
		@see KKeySequence#toString
	*/
	public native String toString();
	/**	
				 		@short
	*/
	public native String toStringInternal(KShortcut pcutDefault);
	public native String toStringInternal();
	/**	
		 Returns a null shortcut.
				@return the null shortcut

		@short    Returns a null shortcut.
		@see #isNull
		@see #clear
	*/
	public static native KShortcut nil();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
