<?xml version="1.0" encoding="utf-8"?>
<!--
    Copyright (c) 2011-2012 KO GmbH.  All rights reserved.
    Copyright (c) 2011-2012 Stuart Dickson <stuartmd@kogmbh.com>
     
    The use and distribution terms for this software are covered by the
    Common Public License 1.0 (http://opensource.org/licenses/cpl1.0.php)
    which can be found in the file CPL.TXT at the root of this distribution.
    By using this software in any fashion, you are agreeing to be bound by
    the terms of this license.
   
    You must not remove this notice, or any other, from this software.
   
    Based on an example from Mark Lines-Davies' blog entry "Preserve GUIDs
    in Wix generated by the Heat harvesting tool" at
    http://marklinesdavies.blogware.com/blog/_archives/2011/3/14/4771326.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:wix="http://schemas.microsoft.com/wix/2006/wi"
        xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
       
        <xsl:output method="xml" indent="yes"/>
       
        <!--Identity Transform-->
        <xsl:template match="@*|node()">
                <xsl:copy>
                        <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
        </xsl:template>
       
 
    <xsl:template name="setId">
      <xsl:param name="programNames"/>
      <xsl:param name="source"/>
      <xsl:variable name="programName" select="substring-before($programNames, ',')" />
      <xsl:choose>
        <xsl:when test="string-length($programName) > 0">
          <xsl:variable name="exeName" select="concat($programName, '.exe')" />
          <xsl:choose>
            <!-- hacking around with contains, as there is no ends-with, should be safe with the possible strings -->
            <xsl:when test="contains($source, $exeName)">
              <xsl:value-of select="$exeName"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="setId">
                <xsl:with-param name="programNames" select="substring($programNames, string-length($programName)+2)"/>
                <xsl:with-param name="source" select="$source"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="." />
        </xsl:otherwise>
      </xsl:choose>
 
    </xsl:template>
 
    <xsl:template match="wix:File/@Id">
      <xsl:variable name="programNames">
        <!-- Always also put a final ',' to the last item -->
        <xsl:text>braindump,calligrasheets,calligrastage,calligrawords,karbon,</xsl:text>
      </xsl:variable>
      <xsl:attribute name="Id">
        <xsl:call-template name="setId">
          <xsl:with-param name="programNames" select="$programNames"/>
          <xsl:with-param name="source" select="../@Source"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:template>
   
        <!--Set up keys of component Ids from PreviousHeatFragment.xml-->
        <xsl:key name="previousfragment-search" match="wix:Component[@Id = document('PreviousHeatFragment.xml')//wix:Component/@Id]" use="@Id"/>
       
    <!--Match Components that also exist in PreviousHeatFragment.xml, and use the previous version of the guid-->
    <xsl:template match="wix:Component[key('previousfragment-search', @Id)]/@Guid">
      <xsl:variable name="Id" select="../@Id"/>
      <xsl:attribute name="Guid">
        <xsl:value-of select="document('PreviousHeatFragment.xml')//wix:Component[@Id = $Id]/@Guid"/>
      </xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
